
pcall(loadfile("_Deflection\\Options.lua"))

-- VARIABLES
local isPlayerDeflecting = 0
local CurrentDeflection = 0
local g_DeflectCancel = false
local DeflectContinueTriggered = false
local ConvergenceMode = false

---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--			 Atualiza o Sistema			   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

------------------------------------------
-- VIZZO - Update Functions
function MainUpdate()
	
	----------------------------
    -- VIZZO - Deflect Status
	CheckCustomOptions()
    ----------------------------
	-- Posture Mode
	CheckPostureMode()
	----------------------------
	-- Deflect Manager
	
	UpdateGuard()
	
	if env(GetSpEffectID, 150812) == TRUE or (env(GetSpEffectID, 150814) == TRUE and env(GetGuardLevelAction) > 0 and env(ActionDuration, ACTION_ARM_L1) > 0 and env(ActionDuration, ACTION_ARM_L1) < 600) then
		if isPlayerDeflecting == 0 or CurrentDeflection == 0 then
            isPlayerDeflecting = 1
            CurrentDeflection = 1
		end
		act(ClearSpEffect, 150814)
		ExecDeflectAnim(damage_angle, attack_dir, guard_damage_level)
	end
	
	if not g_DeflectCancel then
		DeflectCancel()
	end
    ----------------------------
    -- Malenia Lifesteal
	UpdateMaleniaLifesteal()
	----------------------------
    -- AnimJumper
    AnimJumper()
	
end


---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--			 Define Parametros			   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

------------------------------------------
-- Is Player

function IsPlayer()
    if env(IsCOMPlayer) == TRUE then return FALSE end
	return TRUE
end

---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--			  Funções Dinamicas			   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

if not ConvergenceMode then
------------------------------------------
TraversePointerChain = 10000
GAME_BASE = 0
CHR_INS_BASE = 1
TARGET_CHR_INS_BASE = 2

ExposeDebugPrint = 10001

GetEventFlag = 10003

------------------------------------------
WritePointerChain = 10000
UNSIGNED_BYTE = 0
SIGNED_BYTE = 1
UNSIGNED_SHORT = 2
SIGNED_SHORT = 3
UNSIGNED_INT = 4
SIGNED_INT = 5
FLOAT = 6
BIT = 7

UpdateMagicIdToActive = 10002

SetEventFlag = 10003

ESD_ReplaceTool = 100059

GetParamValue = 10004
SetParamValue = 10004


------------------------------------------
PARAM_EquipParamWeapon = 0

PARAM_AtkParam_Npc = 7
PARAM_AtkParam_Pc = 8

PARAM_SpEffectParam = 15

PLAYER_GAME_DATA = 0x580 -- 1.16
EQUIP_GAME_DATA = 0x2b0 -- 1.16
GAME_DATA_MAN = 0x3D5DF38 -- 1.16
CHR_ASM = 0x70
ARM_STYLE = 0x8 -- byte
CURR_WEP_SLOT_OFFSET_LEFT = ARM_STYLE + (0x328 - 0x328) -- int
CURR_WEP_SLOT_OFFSET_RIGHT = ARM_STYLE + (0x32C - 0x328) -- int
L_HAND_WEAPON_1 = ARM_STYLE + (0x398 - 0x328) -- int
L_HAND_WEAPON_2 = ARM_STYLE + (0x3A0 - 0x328) -- int
L_HAND_WEAPON_3 = ARM_STYLE + (0x3A8 - 0x328) -- int
R_HAND_WEAPON_1 = ARM_STYLE + (0x39C - 0x328) -- int
R_HAND_WEAPON_2 = ARM_STYLE + (0x3A4 - 0x328) -- int
R_HAND_WEAPON_3 = ARM_STYLE + (0x3AC - 0x328) -- int
ARROW_1 = ARM_STYLE + (0x3B0 - 0x328) -- int
ARROW_2 = ARM_STYLE + (0x3B8 - 0x328) -- int
BOLT_1 = ARM_STYLE + (0x3B4 - 0x328) -- int
BOLT_2 = ARM_STYLE + (0x3BC - 0x328) -- int

------------------------------------------
-- Other Function Requirements
------------------------------------------
function subtractInt(a, b)
    -- Convert the numbers to strings
    local aStr = tostring(a)
    local bStr = tostring(b)
    
    -- Ensure both numbers are the same length (by padding with zeros)
    local maxLen = math.max(#aStr, #bStr)
    aStr = string.rep("0", maxLen - #aStr) .. aStr
    bStr = string.rep("0", maxLen - #bStr) .. bStr

    -- Subtract each digit from right to left
    local result = {}
    local borrow = 0
    for i = maxLen, 1, -1 do
        local digitA = tonumber(aStr:sub(i, i))
        local digitB = tonumber(bStr:sub(i, i))
        local diff = digitA - digitB - borrow
        if diff < 0 then
            diff = diff + 10
            borrow = 1
        else
            borrow = 0
        end
        table.insert(result, 1, tostring(diff))
    end

    -- Remove leading zeros
    local resultStr = table.concat(result)
    resultStr = resultStr:gsub("^0+", "")  -- Remove leading zeros

    -- If the result is empty (i.e., zero), return "0"
    return resultStr == "" and "0" or resultStr
end

------------------------------------------
-- Equipment Reading Functions
------------------------------------------

local function bytesToInt32(b1, b2, b3, b4)
    -- Convert signed bytes (-128 to 127) to unsigned (0 to 255)
    b1 = (b1 + 256) % 256
    b2 = (b2 + 256) % 256
    b3 = (b3 + 256) % 256
    b4 = (b4 + 256) % 256

    -- Combine bytes in little-endian order correctly
    return b1 + (b2 * 256) + (b3 * 65536) + (b4 * 16777216)
end

function GetEquipmentID(slot)
    if slot == CURR_WEP_SLOT_OFFSET_LEFT or slot == CURR_WEP_SLOT_OFFSET_RIGHT then
        return env(TraversePointerChain, CHR_INS_BASE, SIGNED_INT, PLAYER_GAME_DATA, EQUIP_GAME_DATA + CHR_ASM + slot)
    end

    local b1 = env(TraversePointerChain, CHR_INS_BASE, SIGNED_BYTE, PLAYER_GAME_DATA, (EQUIP_GAME_DATA + CHR_ASM + slot) + 0)
    local b2 = env(TraversePointerChain, CHR_INS_BASE, SIGNED_BYTE, PLAYER_GAME_DATA, (EQUIP_GAME_DATA + CHR_ASM + slot) + 1)
    local b3 = env(TraversePointerChain, CHR_INS_BASE, SIGNED_BYTE, PLAYER_GAME_DATA, (EQUIP_GAME_DATA + CHR_ASM + slot) + 2)
    local b4 = env(TraversePointerChain, CHR_INS_BASE, SIGNED_BYTE, PLAYER_GAME_DATA, (EQUIP_GAME_DATA + CHR_ASM + slot) + 3)

    local floatValue = bytesToInt32(b1, b2, b3, b4)
    return floatValue
end

function GetWeaponSlot(hand)
    if hand == HAND_RIGHT then
        local equippedSlot = GetEquipmentID(CURR_WEP_SLOT_OFFSET_RIGHT)

        if equippedSlot == 0 then
            return R_HAND_WEAPON_1
        elseif equippedSlot == 1 then
            return R_HAND_WEAPON_2
        elseif equippedSlot == 2 then
            return R_HAND_WEAPON_3
        end
    end

    local equippedSlot = GetEquipmentID(CURR_WEP_SLOT_OFFSET_LEFT)
    if equippedSlot == 0 then
        return L_HAND_WEAPON_1
    elseif equippedSlot == 1 then
        return L_HAND_WEAPON_2
    elseif equippedSlot == 2 then
        return L_HAND_WEAPON_3
    end
end

function GetWeaponID(hand)
    return GetEquipmentID(GetWeaponSlot(hand))
end

function CleanWeaponID(id, offset)
    offset = offset or 4
    return subtractInt(id, tonumber(string.sub(tostring(id), 0 - offset)))
end

function ExposePrint(v)
    act(ExposeDebugPrint, tostring(v))
end

------------------------------------------
-- Set Weapon Field
function GetWeaponParamField(weaponId, field, type, bitOffset)
    return env(GetParamValue, PARAM_EquipParamWeapon, weaponId, field, type or SIGNED_INT, bitOffset or 0)
end

function SetWeaponParamField(weaponId, field, value, type, bitOffset)
    return act(SetParamValue, PARAM_EquipParamWeapon, weaponId, field, type or SIGNED_INT, value, bitOffset or 0)
end

end
------------------------------------------
-- Set ATK NPC Field
function SetParamField(ParamID, field, value, type, bitOffset)
    return act(SetParamValue, PARAM_AtkParam_Npc, ParamID, field, type or SIGNED_INT, value, bitOffset or 0)
end

------------------------------------------
-- Set ATK Field
function SetAtkPcParamField(ParamID, field, value, type, bitOffset)
    return act(SetParamValue, PARAM_AtkParam_Pc, ParamID, field, type or FLOAT, value, bitOffset or 0)
end

------------------------------------------
-- Set SPEffect Field
function SetSPEffectField(ParamID, field, value, type, bitOffset)
    return act(SetParamValue, PARAM_SpEffectParam, ParamID, field, type or SIGNED_INT, value, bitOffset or 0)
end

---------------------------------------------------------------------------------------------------------

------------------------------------
-- Malenia Lifesteal
function UpdateMaleniaLifesteal()

    -- Lista de IDs de Malenia
    local MaleniaIDs = {
        [1] = {2120100, 2120110, 2120120, 2120130, 2120140, 2120150, 2120170, 2120180, 2120190, 2120200, 2120201, 2120202, 2120203, 2120204, 2120205, 2120300, 2120310, 2120340, 2120370, 2120380, 2120390, 2120400, 2120401, 2120402, 2120403, 2120404, 2120410, 2120450, 2120460, 2120480, 2120481, 2120482, 2120483, 2120484, 2120485, 2120486, 2120487, 2120488, 2120490, 2120491 },  -- 18412
        [2] = {2120141, 2120160, 2120161, 2120210, 2120220, 2120260, 2120270, 2120500, 2120510, 2120520, 2120530 }, -- 18413
        [3] = {2120209, 2120489, 2120800, 2120801, 2120810, 2120811},  -- 18410
        [4] = {2120230, 2120231, 2120240, 2120241}, -- 18415
        [5] = {2120271, 2120321, 2120470, 2120471, 2120501, 2120502, 2120531, 2120532}, -- 18417
        [6] = {2120290, 2120292, 2120293} -- 18414
    }

    local effectValues = {
        [1] = 18412,
        [2] = 18413,
        [3] = 18410,
        [4] = 18415,
        [5] = 18417,
        [6] = 18414
    }

    -- Executar SetParamField para cada ID nas listas de MaleniaIDs
    for index, maleniaIDsList in pairs(MaleniaIDs) do
        for _, maleniaID in ipairs(maleniaIDsList) do
            if isPlayerDeflecting == 1 then
                SetParamField(maleniaID, 0x18, -1, SIGNED_INT)
            else
                local effectValue = effectValues[index]
                SetParamField(maleniaID, 0x18, effectValue, SIGNED_INT)
            end
        end
    end
end

-- Backups
local AbsorpBackups = {
    physic = nil,
    magic = nil,
    fire = nil,
    lightning = nil,
    holy = nil
}

-- variables
_StabilityParam = 0xD8
local StabilityBackup = nil
local GuardEffectActive = false

-- Offsets dos parâmetros de absorção
local ABSORP_OFFSETS = {
    physic = 0x34,
    magic = 0x38,
    fire = 0x3C,
    lightning = 0x40,
    holy = 0x188
}

function UpdateGuard()
    local rightWeapon = GetWeaponID(HAND_RIGHT)
    local rightModifiers = rightWeapon % 100
    local rightBase = rightWeapon - rightModifiers
    
    local leftWeapon = GetWeaponID(HAND_LEFT)
    local leftModifiers = leftWeapon % 100
    local leftBase = leftWeapon - leftModifiers

    if (env(GetSpEffectID, 150810) == TRUE or env(GetSpEffectID, 150812) == TRUE) then
        if not GuardEffectActive then
            -- Backup de todos os parâmetros de absorção
            if c_Style == HAND_RIGHT_BOTH then
                for absorpType, offset in pairs(ABSORP_OFFSETS) do
                    AbsorpBackups[absorpType] = {
                        equipped = GetWeaponParamField(rightWeapon, offset, FLOAT),
                        base = GetWeaponParamField(rightBase, offset, FLOAT)
                    }
                end
                
                StabilityBackup = {
                    equipped = GetWeaponParamField(rightWeapon, _StabilityParam, SIGNED_INT),
                    base = GetWeaponParamField(rightBase, _StabilityParam, SIGNED_INT)
                }

                -- Aplicar modificações
                -- Sempre modifica absorção física
                SetWeaponParamField(rightWeapon, ABSORP_OFFSETS.physic, CUSTOM_ABSORP_VALUES.physic, FLOAT)
                SetWeaponParamField(rightBase, ABSORP_OFFSETS.physic, CUSTOM_ABSORP_VALUES.physic, FLOAT)
                
                -- Modifica os outros apenas se ENABLE_CUSTOM_ABSORP = true
                if ENABLE_CUSTOM_ABSORP then
                    for absorpType, offset in pairs(ABSORP_OFFSETS) do
                        if absorpType ~= "physic" then  -- Já modificamos o físico acima
                            SetWeaponParamField(rightWeapon, offset, CUSTOM_ABSORP_VALUES[absorpType], FLOAT)
                            SetWeaponParamField(rightBase, offset, CUSTOM_ABSORP_VALUES[absorpType], FLOAT)
                        end
                    end
                end
                
                SetWeaponParamField(rightWeapon, _StabilityParam, 100, SIGNED_INT)
                SetWeaponParamField(rightBase, _StabilityParam, 100, SIGNED_INT)
                
            elseif c_Style == HAND_LEFT_BOTH then
                for absorpType, offset in pairs(ABSORP_OFFSETS) do
                    AbsorpBackups[absorpType] = {
                        equipped = GetWeaponParamField(leftWeapon, offset, FLOAT),
                        base = GetWeaponParamField(leftBase, offset, FLOAT)
                    }
                end
                
                StabilityBackup = {
                    equipped = GetWeaponParamField(leftWeapon, _StabilityParam, SIGNED_INT),
                    base = GetWeaponParamField(leftBase, _StabilityParam, SIGNED_INT)
                }

                -- Aplicar modificações
                -- Sempre modifica absorção física
                SetWeaponParamField(leftWeapon, ABSORP_OFFSETS.physic, CUSTOM_ABSORP_VALUES.physic, FLOAT)
                SetWeaponParamField(leftBase, ABSORP_OFFSETS.physic, CUSTOM_ABSORP_VALUES.physic, FLOAT)
                
                -- Modifica os outros apenas se ENABLE_CUSTOM_ABSORP = true
                if ENABLE_CUSTOM_ABSORP then
                    for absorpType, offset in pairs(ABSORP_OFFSETS) do
                        if absorpType ~= "physic" then  -- Já modificamos o físico acima
                            SetWeaponParamField(leftWeapon, offset, CUSTOM_ABSORP_VALUES[absorpType], FLOAT)
                            SetWeaponParamField(leftBase, offset, CUSTOM_ABSORP_VALUES[absorpType], FLOAT)
                        end
                    end
                end
                
                SetWeaponParamField(leftWeapon, _StabilityParam, 100, SIGNED_INT)
                SetWeaponParamField(leftBase, _StabilityParam, 100, SIGNED_INT)
            end

            GuardEffectActive = true
        end
    elseif (env(GetSpEffectID, 150810) == FALSE and env(GetSpEffectID, 150812) == FALSE) then
        if GuardEffectActive then
            -- Restaurar todos os parâmetros
            if c_Style == HAND_RIGHT_BOTH then
                -- Restaurar absorções
                for absorpType, offset in pairs(ABSORP_OFFSETS) do
                    if AbsorpBackups[absorpType] then
                        SetWeaponParamField(rightWeapon, offset, AbsorpBackups[absorpType].equipped, FLOAT)
                        SetWeaponParamField(rightBase, offset, AbsorpBackups[absorpType].base, FLOAT)
                    end
                end
                
                -- Restaurar estabilidade
                SetWeaponParamField(rightWeapon, _StabilityParam, StabilityBackup.equipped, SIGNED_INT)
                SetWeaponParamField(rightBase, _StabilityParam, StabilityBackup.base, SIGNED_INT)

            elseif c_Style == HAND_LEFT_BOTH then
                -- Restaurar absorções
                for absorpType, offset in pairs(ABSORP_OFFSETS) do
                    if AbsorpBackups[absorpType] then
                        SetWeaponParamField(leftWeapon, offset, AbsorpBackups[absorpType].equipped, FLOAT)
                        SetWeaponParamField(leftBase, offset, AbsorpBackups[absorpType].base, FLOAT)
                    end
                end
                
                -- Restaurar estabilidade
                SetWeaponParamField(leftWeapon, _StabilityParam, StabilityBackup.equipped, SIGNED_INT)
                SetWeaponParamField(leftBase, _StabilityParam, StabilityBackup.base, SIGNED_INT)
            end

            -- Limpar backups
            AbsorpBackups = {
                physic = nil,
                magic = nil,
                fire = nil,
                lightning = nil,
                holy = nil
            }
            StabilityBackup = nil
            GuardEffectActive = false
        end
    end
end

---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--			  Sistema de deflexao		   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

------------------------------------------
-- Check CustomOptions

function CheckCustomOptions()
	if IsPlayer() == TRUE then
		SetSPEffectField(150810, 0x8, CUSTOM_DEFLECTION_TIME, FLOAT)

		if CUSTOM_NO_ATTACK_CANCEL == 1 then
			SetSPEffectField(150810, 0x130, 0.000, FLOAT)
		else
			SetSPEffectField(150810, 0x130, 2.500, FLOAT)
		end
	
		SetAtkPcParamField(580,  0x1b0, CUSTOM_POISE_DAMAGE, FLOAT)
	end
end

------------------------------------------
-- Apply Effect

function ApplyDeflectStatus()
	local R_BannedList = GetEquipType(HAND_RIGHT, 
			WEAPON_CATEGORY_SMALL_SHIELD, WEAPON_CATEGORY_MIDDLE_SHIELD, 
				WEAPON_CATEGORY_LARGE_SHIELD, WEAPON_CATEGORY_DUELING_SHIELD,
					WEAPON_CATEGORY_TORCH, WEAPON_CATEGORY_STAFF, WEAPON_CATEGORY_BALISTA, 
				WEAPON_CATEGORY_BALLISTA, WEAPON_CATEGORY_SMALL_ARROW, WEAPON_CATEGORY_ARROW, 
			WEAPON_CATEGORY_LARGE_ARROW, WEAPON_CATEGORY_CROSSBOW)
							
	local L_BannedList = GetEquipType(HAND_LEFT, 
			WEAPON_CATEGORY_SMALL_SHIELD, WEAPON_CATEGORY_MIDDLE_SHIELD, 
				WEAPON_CATEGORY_LARGE_SHIELD, WEAPON_CATEGORY_DUELING_SHIELD,
					WEAPON_CATEGORY_TORCH, WEAPON_CATEGORY_STAFF, WEAPON_CATEGORY_BALISTA, 
				WEAPON_CATEGORY_BALLISTA, WEAPON_CATEGORY_SMALL_ARROW, WEAPON_CATEGORY_ARROW, 
			WEAPON_CATEGORY_LARGE_ARROW, WEAPON_CATEGORY_CROSSBOW)

    if CurrentDeflection == 0 and env(GetSpEffectID, 102000) == FALSE and not SHIELD_CAN_DEFLECT
		and ((c_Style == HAND_RIGHT_BOTH and R_BannedList == FALSE) 
			or (c_Style == HAND_LEFT_BOTH and L_BannedList == FALSE)) then
			
		if env(ActionDuration, ACTION_ARM_L1) > 600 or env(GetSpEffectID, 150810) == TRUE then
			return
		else
			act(AddSpEffect, 150810)
		end
        
        DeflectionStart()
elseif CurrentDeflection == 0 and env(GetSpEffectID, 102000) == FALSE and SHIELD_CAN_DEFLECT then
		if env(ActionDuration, ACTION_ARM_L1) > 600 or env(GetSpEffectID, 150810) == TRUE then
			return
		else
			act(AddSpEffect, 150810)
		end
        
        DeflectionStart()
	end
end

------------------------------------------
-- Deflection Start

function DeflectionStart()
    if (c_Style == HAND_RIGHT_BOTH or c_Style == HAND_LEFT_BOTH) or SHIELD_CAN_DEFLECT then
        if env(GetSpEffectID, 150810) == TRUE then
            isPlayerDeflecting = 1
            CurrentDeflection = 1
        end
    end
end

function DeflectCancel()
    if (isPlayerDeflecting == 1 and env(ActionDuration, ACTION_ARM_R1) > 0) 
		or (isPlayerDeflecting == 1 and env(GetSpEffectID, 150810) == FALSE) or env(GetHP) <= 0 then
            g_DeflectCancel = true
        DeflectionEnd()
    end
end

------------------------------------------
-- Exec Deflection Anim

function ExecDeflectAnim(damage_angle, attack_dir, guard_damage_level)
    local anim
	
	local RBothStyle = c_Style == HAND_RIGHT_BOTH
	local LBothStyle = c_Style == HAND_LEFT_BOTH
	local GreatKatanaKind = env(GetEquipWeaponSpecialCategoryNumber, HAND_RIGHT) == 726

        -- Define animações para deflexão
    local deflectAnims = {
            [1] = { LEFT = "W_Deflect_S_L", RIGHT = "W_Deflect_S_R", DEFAULT = "W_Deflect_S_U" },
            [3] = { LEFT = "W_Deflect_M_L", RIGHT = "W_Deflect_M_R", DEFAULT = "W_Deflect_M_U" },
            [4] = "W_Deflect_B",
            [5] = { LEFT = "W_Deflect_L_L", RIGHT = "W_Deflect_L_R", DEFAULT = "W_Deflect_L_U" }
    }
	
        -- Define animações para deflexão com a Great Katana
    local GreatKatanaAnims = {
            [1] = { LEFT = "W_Deflect_M_L", RIGHT = "W_Deflect_M_R", DEFAULT = "W_Deflect_M_U" },
            [3] = { LEFT = "W_Deflect_M_L", RIGHT = "W_Deflect_M_R", DEFAULT = "W_Deflect_M_U" },
            [4] = "W_Deflect_B",
            [5] = { LEFT = "W_Deflect_L_L", RIGHT = "W_Deflect_L_R", DEFAULT = "W_Deflect_L_U" }
    }
	
	local shieldAnim = {
            [1] = { LEFT = "W_Deflect_Shield_L", RIGHT = "W_Deflect_Shield_R", DEFAULT = "W_Deflect_Shield_U" },
            [3] = { LEFT = "W_Deflect_Shield_L", RIGHT = "W_Deflect_Shield_R", DEFAULT = "W_Deflect_Shield_U" },
            [4] = "W_Deflect_Shield_B",
            [5] = { LEFT = "W_Deflect_Shield_L", RIGHT = "W_Deflect_Shield_R", DEFAULT = "W_Deflect_Shield_U" },
	
	}
							
	local L_Shield = GetEquipType(HAND_LEFT, 
			WEAPON_CATEGORY_SMALL_SHIELD, WEAPON_CATEGORY_MIDDLE_SHIELD, 
				WEAPON_CATEGORY_LARGE_SHIELD, WEAPON_CATEGORY_DUELING_SHIELD)
        
        -- Determina qual animação aplicar
        local function getAnim(animTable, level, dir)
				local levelAnims = animTable[level]
				
            if type(levelAnims) == "table" then
                if levelAnims.RANDOM then
                    return levelAnims.RANDOM[math.random(1, #levelAnims.RANDOM)]
                else
                    return dir == ATTACK_DIR_RIGHT and levelAnims.RIGHT
                           or (dir == ATTACK_DIR_LEFT and levelAnims.LEFT
						or levelAnims.DEFAULT)
                end
            else
                return levelAnims
            end
        end

    -- Executa a animação de deflexao
	if guard_damage_level > 0 then
		if CurrentDeflection == 1 then
			if LBothStyle or RBothStyle or SHIELD_CAN_DEFLECT then
				if SHIELD_CAN_DEFLECT and L_Shield == TRUE and c_Style ~= HAND_RIGHT_BOTH and c_Style ~= HAND_LEFT_BOTH then
					anim = getAnim(shieldAnim, guard_damage_level, attack_dir)
				else
					if GreatKatanaKind and c_Style == HAND_RIGHT_BOTH then
						anim = getAnim(GreatKatanaAnims, guard_damage_level, attack_dir)
					else
						anim = getAnim(deflectAnims, guard_damage_level, attack_dir)
					end
				end
				
					act(AddSpEffect, 150824)
						DeflectContinueTriggered = false
					
						if g_RecoverPostureTime > 0 then
							g_RecoverPostureTime = 1
						end
					
					ExecEventAllBody(anim)
				return TRUE
			end
		else
			act(AddSpEffect, 150824)
		end
	end

    return FALSE
end

------------------------------------------
-- Deflection End
function DeflectionEnd()
    if CurrentDeflection == 1 then
        isPlayerDeflecting = 0
        CurrentDeflection = 0
        g_DeflectCancel = false
    end
end

----------------------------------

g_RecoverPostureTime = 0
g_RecoverPostureTimeNPC = 0
local g_IsGuardBreak = false
g_IsGuardBreakNPC = false
function CheckPostureMode()
    if ENABLE_POSTURE_MODE == 1 or ENABLE_POSTURE_MODE == 2 then
        local CurrentPoise = env(GetPoise)
        local MaxPoise = env(GetMaxPoise)

        -- Chama o sistema de postura para aplicar lógica específica do jogador ou NPC
        PostureSystem()

        -- Bloco para o jogador
        if IsPlayer() == TRUE then
            if g_RecoverPostureTime >= 1 then
                if CurrentPoise < MaxPoise then
                    act(AddSpEffect, 150823)
                end

                g_RecoverPostureTime = g_RecoverPostureTime + 1
            end

            -- Verifica o tempo máximo para recuperação do jogador
            if g_RecoverPostureTime >= 600 then
                g_RecoverPostureTime = 0
            end

            -- Se o jogador tiver a postura quebrada, reseta o tempo de recuperação
            if PostureSystem() == TRUE then
                g_RecoverPostureTime = 0
                g_IsGuardBreak = true
            end

        -- Bloco para o NPC
        elseif IsPlayer() == FALSE then
            if g_RecoverPostureTimeNPC >= 1 then
                if CurrentPoise < MaxPoise then
                    act(AddSpEffect, 150823)
                end

                g_RecoverPostureTimeNPC = g_RecoverPostureTimeNPC + 1
            end

            -- Verifica o tempo máximo para recuperação do NPC
            if g_RecoverPostureTimeNPC >= 600 then
                g_RecoverPostureTimeNPC = 0
            end

            -- Se o NPC tiver a postura quebrada, reseta o tempo de recuperação
            if PostureSystem() == BREAKNPC then
                g_RecoverPostureTimeNPC = 0
                g_IsGuardBreakNPC = true
            end
        end
    end
end

function PostureSystem()
    local CurrentPoise = env(GetPoise)
    local IsDuringDeflect = env(GetSpEffectID, 150824)
    local guard_damage_level = env(GetGuardLevelAction)

    -- Verifica o modo de postura
    if ENABLE_POSTURE_MODE == 1 then
        -- Bloco para o jogador
        if IsPlayer() == TRUE then
            if CurrentPoise > 20 and IsDuringDeflect == TRUE then
                act(AddSpEffect, 150821)
                g_RecoverPostureTime = 1
            elseif CurrentPoise > 20 and env(HasReceivedAnyDamage) == TRUE then
                act(AddSpEffect, 150821)
            end

            if CurrentPoise <= 20 and env(HasReceivedAnyDamage) == TRUE and (guard_damage_level > 0 and CurrentDeflection == 0) then
                return TRUE
            end
        -- Bloco para NPC
        elseif IsPlayer() == FALSE then
            if CurrentPoise > 15 and (env(HasReceivedAnyDamage) == TRUE or env(GetSpEffectID, 150813) == TRUE) then
                act(AddSpEffect, 150821)
                g_RecoverPostureTimeNPC = 1
            end

            if CurrentPoise <= 10 and (env(HasBrokenSA) == TRUE or env(GetSpEffectID, 150813) == TRUE) and not g_IsGuardBreakNPC then
                return BREAKNPC
            end
        end

    elseif ENABLE_POSTURE_MODE == 2 then
        -- Bloco para NPC
        if IsPlayer() == FALSE then
            if CurrentPoise > 10 and (env(HasReceivedAnyDamage) == TRUE or env(GetSpEffectID, 150813) == TRUE) then
                act(AddSpEffect, 150821)
                g_RecoverPostureTimeNPC = 1
            end

            if CurrentPoise <= 10 and (env(HasBrokenSA) == TRUE or env(GetSpEffectID, 150813) == TRUE) and not g_IsGuardBreakNPC then
                return BREAKNPC
            end
        end
    end

    return FALSE
end

---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--			  Funções de Transição		   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

------------------------------------------
-- Animation Jumper

    -- Animation Jumpers:

function AnimJumper()
	---------------------
    -- GuardBreak
    -- Bloco para o jogador
	if IsPlayer() == TRUE then
		if g_IsGuardBreak then
			g_IsGuardBreak = false
				act(SetDamageAnimType, DAMAGE_FLAG_GUARD_BREAK)
				act(AddSpEffect, 150822)
			ExecEventAllBody("W_GuardBreak")
		end
		
    -- Bloco para NPC
	elseif IsPlayer() == FALSE then
		if g_IsGuardBreakNPC then
			g_IsGuardBreakNPC = false
				act(SetDamageAnimType, DAMAGE_FLAG_GUARD_BREAK)
				act(AddSpEffect, 150822)
			ExecEventAllBody("W_GuardBreak")
		end
	end
end

---------------------------------------------------------------------------------------------------------

-- Parâmetros comuns para todos os ataques
function UpdateAnime()
    if AttackCommonFunction("W_AttackRightLight1", "W_AttackRightHeavy1Start", "W_AttackLeftLight1",
        "W_AttackLeftHeavy1", "W_AttackBothLight1", "W_AttackBothHeavy1Start", FALSE, TRUE, 0) == TRUE then
    end
end

function DeflectContinueWindow()
	if not DeflectContinueTriggered then
		if env(GetSpEffectID, 150811) == TRUE and env(GetSpEffectID, 150812) == FALSE and env(GetSpEffectID, 150810) == FALSE 
			and env(ActionDuration, ACTION_ARM_L1) > 0 and env(ActionDuration, ACTION_ARM_L1) < 300 then
			act(AddSpEffect, 150812)
			DeflectContinueTriggered = true
		end
	end
end

function Deflect_S_U_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_S_L_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_S_R_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_M_U_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_M_L_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_M_R_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_L_U_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_L_L_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_L_R_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_B_onUpdate() UpdateAnime() end

function Deflect_Shield_U_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_Shield_L_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_Shield_R_onUpdate() UpdateAnime() DeflectContinueWindow() end
function Deflect_Shield_B_onUpdate() UpdateAnime() end

function SekiroCounter_Anime1_onUpdate() UpdateAnime() end
function SekiroCounter_Anime2_onUpdate() UpdateAnime() end
function SekiroCounter_Anime3_onUpdate() UpdateAnime() end
function SekiroCounter_Anime4_onUpdate() UpdateAnime() end
function SekiroCounter_Anime5_onUpdate() UpdateAnime() end
function SekiroCounter_Anime6_onUpdate() UpdateAnime() end

---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
								---------------------------------------------
								--					Detour				   --
								---------------------------------------------
---------------------------------------------------------------------------------------------------------

-- Function to create a detour
function VIZZODeflectionDetour(originalFunction, newFunction)
    -- Store the original function in the new function's environment
    local original = originalFunction
    -- Create a wrapper that calls the new function first, then the original function
    return function(...)
        -- Call the new function
        newFunction(...)
        -- Call the original function
        return original(...)
    end
end

Update = VIZZODeflectionDetour(Update, MainUpdate)